<?php

namespace App\Http\Controllers;

use App\Models\Permission;
use Illuminate\Http\Request;

class PermissionController extends Controller
{
    public function index()
    {
        $permissions = Permission::orderBy('group')->get();
        return view('permissions.index', compact('permissions'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|unique:permissions,name',
            'group' => 'required|string',
        ]);

        Permission::create([
            'name' => $request->name,
            'group' => $request->group,
        ]);

        return back()->with('success', 'تمت إضافة الصلاحية بنجاح.');
    }
}
