<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use App\Models\ActivityLog;

class LoginController extends Controller
{
    public function showLoginForm()
    {

            if (Auth::check()) {
                return redirect('/dashboard');
            }
            return view('auth.login');



    }

    public function login(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'email' => 'required|email',
            'password' => 'required|min:6',
        ], [
            'email.required' => 'البريد الإلكتروني مطلوب',
            'email.email' => 'البريد الإلكتروني غير صحيح',
            'password.required' => 'كلمة المرور مطلوبة',
            'password.min' => 'كلمة المرور يجب أن تكون 6 أحرف على الأقل',
        ]);

        if ($validator->fails()) {
            return back()->withErrors($validator)->withInput();
        }

        $credentials = $request->only('email', 'password');
        $remember = $request->has('remember');

        if (Auth::attempt($credentials, $remember)) {
            $user = Auth::user();

            // Check if user is active
            if (!$user->is_active) {
                Auth::logout();
                return back()->withErrors(['email' => 'حسابك غير مفعل. يرجى التواصل مع المدير.']);
            }

            // Log the login activity
            ActivityLog::create([
                'user_id' => $user->id,
                'action' => 'login',
                'description' => 'تسجيل دخول المستخدم',
                'ip_address' => $request->ip(),
                'user_agent' => $request->userAgent(),
            ]);

            $request->session()->regenerate();

            return redirect()->intended('/dashboard');
        }

        return back()->withErrors(['email' => 'بيانات الدخول غير صحيحة.'])->withInput();
    }

    public function logout(Request $request)
    {
        $user = Auth::user();

        if ($user) {
            // Log the logout activity
            ActivityLog::create([
                'user_id' => $user->id,
                'action' => 'logout',
                'description' => 'تسجيل خروج المستخدم',
                'ip_address' => $request->ip(),
                'user_agent' => $request->userAgent(),
            ]);
        }

        Auth::logout();
        $request->session()->invalidate();
        $request->session()->regenerateToken();

        return redirect('/login');
    }
}
