<?php

use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\URL;

if (!function_exists('tenant')) {
    function tenant() {
        return App::bound('currentTenant') ? App::make('currentTenant') : null;
    }
}

if (!function_exists('tenant_id')) {
    function tenant_id() {
        return tenant()?->id;
    }
}

/**
 * Override for route() helper
 */
if (! function_exists('route')) {
    function route($name, $parameters = [], $absolute = true)
    {
        return URL::signedRoute($name, $parameters, $absolute);
    }
}
