<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Events\QueueUpdated;
use App\Events\NewDisplay;

class TestWebSockets extends Command
{
    protected $signature = 'websockets:test {tenantId=1}';
    protected $description = 'Test WebSocket broadcasting with Laravel WebSockets';

    public function handle()
    {
        $tenantId = $this->argument('tenantId');
        
        $this->info("Testing WebSocket broadcasting for tenant ID: {$tenantId}");
        
        try {
            // Test QueueUpdated event
            $this->info("Broadcasting QueueUpdated event...");
            broadcast(new QueueUpdated($tenantId));
            $this->info("✅ QueueUpdated event broadcasted successfully");
            
            // Test NewDisplay event  
            $this->info("Broadcasting NewDisplay event...");
            broadcast(new NewDisplay($tenantId));
            $this->info("✅ NewDisplay event broadcasted successfully");
            
            $this->info("🎉 WebSocket test completed successfully!");
            $this->info("Make sure the WebSocket server is running: php artisan websockets:serve");
            
        } catch (\Exception $e) {
            $this->error("❌ WebSocket test failed: " . $e->getMessage());
            return 1;
        }
        
        return 0;
    }
}