<?php

namespace App\Casts;

use Carbon\Carbon;
use Illuminate\Contracts\Database\Eloquent\CastsAttributes;

class TenantAwareDateTime implements CastsAttributes
{
    public function get($model, string $key, $value, array $attributes)
    {
        if (empty($value)) {
            return null;
        }
        $tenantTz = app()->has('tenant.tz') ? app('tenant.tz') : 'UTC';

        // نخزّن في DB كـ UTC، ونرجع للمستهلك بزمن التينانت
        return Carbon::parse($value, 'UTC')->setTimezone($tenantTz);
    }

    public function set($model, string $key, $value, array $attributes)
    {
        if (empty($value)) {
            return null;
        }
        $tenantTz = app()->has('tenant.tz') ? app('tenant.tz') : 'UTC';

        // نقبل string أو Carbon. نفترض أن الإدخال من واجهة المستخدم بزمن التينانت
        if ($value instanceof Carbon) {
            $local = $value->copy();
        } else {
            $local = Carbon::parse($value, $tenantTz);
        }

        // خزّن دائمًا في DB كـ UTC
        return $local->clone()->setTimezone('UTC')->toDateTimeString();
    }
}
